/**
 * 
 */
package gov.va.genisis2.service;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.WorkflowStatus;

/**
 * @author 586338
 *
 */
public interface IRequestService {
	public int createRequest(Request request)throws GenisisServiceException;

	public List<Request> getRequestsByUID(String uid)throws GenisisServiceException;

	public List<Request> getRequestsByDataManagers(String uid)throws GenisisServiceException;

	public List<Request> getRequestsDataManagers(String uid)throws GenisisServiceException;

	public List<Request> getRequestsDataSourceManagers(String uid)throws GenisisServiceException;

	public Request getRequestById(int id)throws GenisisServiceException;

	public List<Request> getAllRequests() throws GenisisServiceException;

	public List<Request> getAllRequestsByStudyApproval(int studyApprovalId)throws GenisisServiceException;

	public List<Request> getAllRequestsByStaus(String status)throws GenisisServiceException;

	public int submitOrModify(Request request)throws GenisisServiceException;

	public int submitOrModify(RequestHistory requestHistory)throws GenisisServiceException;

	public List<RequestHistory> getRequestHistoriesById(int requestId) throws GenisisServiceException;

	public List<RequestHistory> getRequestHistoriesByRequestIdAndStatus(int requestId, String status)throws GenisisServiceException;
	
	public List<RequestHistory> getRequestHistoriesWithCommentsById(int requestId) throws GenisisServiceException;
	
	public List<WorkflowStatus> getRequestStatusCounts() throws GenisisServiceException;
	
	public WorkflowStatus getWorkflowStatus(String status) throws GenisisServiceException;

}
